/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.blocks.entity;

import com.jesz.createdieselgenerators.blocks.DieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.LargeDieselGeneratorBlock;
import com.jesz.createdieselgenerators.blocks.entity.LargeDieselGeneratorValueBox;
import com.jesz.createdieselgenerators.config.ConfigRegistry;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class LargeDieselGeneratorBlockEntity
extends GeneratingKineticBlockEntity {
    BlockState state;
    boolean weak;
    boolean slow;
    public boolean validFuel;
    public int stacked;
    public boolean powered = false;
    boolean end = true;
    private final TagKey<Fluid> tagSS;
    private final TagKey<Fluid> tagFS;
    private final TagKey<Fluid> tagFW;
    private final TagKey<Fluid> tagSW;
    private final TagKey<Fluid> tagPlantOil;
    private final TagKey<Fluid> tagFuel;
    private final TagKey<Fluid> tagEthanol;
    private final TagKey<Fluid> tagBiodiesel;
    public WeakReference<LargeDieselGeneratorBlockEntity> forw = new WeakReference<Object>(null);
    public WeakReference<LargeDieselGeneratorBlockEntity> back = new WeakReference<Object>(null);
    private SmartFluidTankBehaviour tank;
    public LargeDieselGeneratorBlockEntity mainTankBE;
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public LargeDieselGeneratorBlockEntity FrontEngine;
    int t = 0;
    boolean lastp = true;

    public LargeDieselGeneratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.tagSS = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_slow_strong"));
        this.tagSW = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_slow_weak"));
        this.tagFS = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_fast_strong"));
        this.tagFW = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("createdieselgenerators:diesel_engine_fuel_fast_weak"));
        this.tagPlantOil = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:plantoil"));
        this.tagFuel = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:fuel"));
        this.tagEthanol = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:ethanol"));
        this.tagBiodiesel = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.FLUIDS, (ResourceLocation)new ResourceLocation("forge:biodiesel"));
        this.state = state;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (((Boolean)this.state.m_61143_((Property)LargeDieselGeneratorBlock.PIPE)).booleanValue() && cap == ForgeCapabilities.FLUID_HANDLER && side == Direction.UP) {
            if (this.FrontEngine != null) {
                return this.FrontEngine.tank.getCapability().cast();
            }
            return this.tank.getCapability().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.tank.write(compound, false);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.read(compound, false);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)Lang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new LargeDieselGeneratorValueBox());
        this.movementDirection.withCallback($ -> this.onDirectionChanged(true));
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviours);
    }

    public void onDirectionChanged(boolean first) {
        if (first && this.getEngineFor() != null) {
            this.FrontEngine.movementDirection.setValue(this.movementDirection.getValue());
            this.FrontEngine.onDirectionChanged(false);
            return;
        }
        this.movementDirection.setValue(this.FrontEngine.movementDirection.getValue());
        if (this.getEngineBack() != null) {
            this.getEngineBack().onDirectionChanged(false);
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float calculateAddedStressCapacity() {
        if (this.getGeneratedSpeed() == 0.0f || !this.end) {
            return 0.0f;
        }
        if (this.weak) {
            return ((Double)ConfigRegistry.WEAK_STRESS.get()).floatValue() / Math.abs(this.getGeneratedSpeed()) * (float)this.stacked;
        }
        return ((Double)ConfigRegistry.STRONG_STRESS.get()).floatValue() / Math.abs(this.getGeneratedSpeed()) * (float)this.stacked;
    }

    public float getGeneratedSpeed() {
        if (this.validFuel) {
            if (this.slow) {
                return LargeDieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * ((Double)ConfigRegistry.SLOW_SPEED.get()).floatValue()), (Direction)((Direction)this.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.FACING)));
            }
            return LargeDieselGeneratorBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * ((Double)ConfigRegistry.FAST_SPEED.get()).floatValue()), (Direction)((Direction)this.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.FACING)));
        }
        return 0.0f;
    }

    public void UpdateStacked() {
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        LargeDieselGeneratorBlockEntity engineBack = this.getEngineBack();
        this.stacked = engineBack == null ? 1 : engineBack.stacked + 1;
        if (engineForward == null) {
            this.SetEveryEnginesFront();
        } else {
            engineForward.UpdateStacked();
        }
    }

    public void SetEveryEnginesFront() {
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        LargeDieselGeneratorBlockEntity engineBack = this.getEngineBack();
        this.FrontEngine = engineForward == null ? this : engineForward.FrontEngine;
        if (engineBack != null) {
            engineBack.SetEveryEnginesFront();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!IRotate.StressImpact.isEnabled() || this.FrontEngine == null) {
            return added;
        }
        float stressBase = this.FrontEngine.calculateAddedStressCapacity();
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return added;
        }
        if (this.FrontEngine != this) {
            Lang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
            Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            float stressTotal = Math.abs(this.FrontEngine.getGeneratedSpeed() * stressBase);
            Lang.number((double)stressTotal).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        }
        Lang.translate((String)"gui.goggles.fluid_container", (Object[])new Object[0]).forGoggles(tooltip);
        Lang.fluidName((FluidStack)this.FrontEngine.tank.getPrimaryHandler().getFluid()).style(ChatFormatting.GRAY).space().add(Lang.number((double)this.FrontEngine.tank.getPrimaryHandler().getFluid().getAmount()).style(ChatFormatting.DARK_GRAY)).add(Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip);
        return true;
    }

    public void tick() {
        super.tick();
        LargeDieselGeneratorBlockEntity engineForward = this.getEngineFor();
        LargeDieselGeneratorBlockEntity engineBack = this.getEngineBack();
        this.state = this.m_58900_();
        boolean bl = this.end = engineForward == null;
        if (this.reActivateSource) {
            this.updateGeneratedRotation();
            this.reActivateSource = false;
        }
        if (engineBack == null) {
            this.UpdateStacked();
        }
        if (!this.tank.isEmpty() && engineForward != null && this.FrontEngine != null) {
            this.FrontEngine.tank.getPrimaryHandler().fill(this.tank.getPrimaryHandler().getFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.tank.getPrimaryHandler().drain(this.tank.getPrimaryHandler().getFluid(), IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.tank.getPrimaryHandler().getFluid().getAmount() >= this.stacked) {
            if (this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagFS) || ((Boolean)ConfigRegistry.FUEL_TAG.get()).booleanValue() && this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagFuel) || ((Boolean)ConfigRegistry.BIODIESEL_TAG.get()).booleanValue() && this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagBiodiesel)) {
                this.validFuel = true;
                this.slow = false;
                this.weak = false;
            } else if (this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagFW) || ((Boolean)ConfigRegistry.ETHANOL_TAG.get()).booleanValue() && this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagEthanol)) {
                this.validFuel = true;
                this.slow = false;
                this.weak = true;
            } else if (this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagSS) || ((Boolean)ConfigRegistry.PLANTOIL_TAG.get()).booleanValue() && this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagPlantOil)) {
                this.validFuel = true;
                this.slow = true;
                this.weak = false;
            } else if (this.tank.getPrimaryHandler().getFluid().getFluid().m_205067_(this.tagSW)) {
                this.validFuel = true;
                this.slow = true;
                this.weak = true;
            } else {
                this.validFuel = false;
            }
        } else {
            this.validFuel = false;
        }
        this.lastp = (Boolean)this.m_58900_().m_61143_((Property)LargeDieselGeneratorBlock.POWERED);
        if (this.end) {
            if (this.lastp != this.validFuel) {
                this.changeBlockState((BlockState)this.m_58900_().m_61124_((Property)LargeDieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
            }
            this.updateGeneratedRotation();
            this.powered = this.getGeneratedSpeed() != 0.0f;
        } else {
            this.powered = engineForward.powered;
            if (this.lastp != this.powered) {
                this.changeBlockState((BlockState)this.m_58900_().m_61124_((Property)LargeDieselGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
            }
        }
        if (this.t > 2 && this.end) {
            if (this.validFuel && this.tank.getPrimaryHandler().getFluid().getAmount() >= this.stacked) {
                this.tank.getPrimaryHandler().setFluid(FluidHelper.copyStackWithAmount((FluidStack)this.tank.getPrimaryHandler().getFluid(), (int)(this.tank.getPrimaryHandler().getFluid().getAmount() - this.stacked)));
            }
            this.t = 0;
        } else {
            ++this.t;
        }
        if (this.t > 2 && this.powered && !((Boolean)this.state.m_61143_((Property)DieselGeneratorBlock.SILENCED)).booleanValue()) {
            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_144098_, SoundSource.BLOCKS, 0.4f, 1.18f, false);
            AllSoundEvents.STEAM.playAt(this.f_58857_, (Vec3i)this.f_58858_, 0.03f, 0.8f, false);
        }
    }

    private void changeBlockState(BlockState state) {
        this.f_58857_.m_7731_(this.m_58899_(), state, 3);
    }

    private LargeDieselGeneratorBlockEntity getEngineFor() {
        LargeDieselGeneratorBlockEntity engine = (LargeDieselGeneratorBlockEntity)((Object)this.forw.get());
        if (engine == null || engine.m_58901_() || engine.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING) == this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)) {
            Direction facing;
            BlockEntity be;
            if (engine != null) {
                this.forw = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_((facing = (Direction)this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)).m_122424_()))) instanceof LargeDieselGeneratorBlockEntity) {
                LargeDieselGeneratorBlockEntity engineBE;
                engine = engineBE = (LargeDieselGeneratorBlockEntity)be;
                this.forw = new WeakReference<LargeDieselGeneratorBlockEntity>(engine);
            }
        }
        if (engine != null && engine.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING) != this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)) {
            this.forw = new WeakReference<Object>(null);
            return null;
        }
        return engine;
    }

    private LargeDieselGeneratorBlockEntity getEngineBack() {
        LargeDieselGeneratorBlockEntity engine = (LargeDieselGeneratorBlockEntity)((Object)this.back.get());
        if (engine == null || engine.m_58901_()) {
            Direction facing;
            BlockEntity be;
            if (engine != null) {
                this.back = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing = (Direction)this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)))) instanceof LargeDieselGeneratorBlockEntity) {
                LargeDieselGeneratorBlockEntity engineBE;
                engine = engineBE = (LargeDieselGeneratorBlockEntity)be;
                this.back = new WeakReference<LargeDieselGeneratorBlockEntity>(engine);
            }
        }
        if (engine != null && engine.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING) != this.state.m_61143_((Property)LargeDieselGeneratorBlock.FACING)) {
            this.back = new WeakReference<Object>(null);
            return null;
        }
        return engine;
    }
}

